// Sample code that uses MMenu.lib
// by Olivier Wittenberg (witt@lenet.fr)
//
// This application opens an empty window, and tries to export
// the main menu. If failed, the main menu is added to the window,
// in a menu bar. It also shows that the targets are kept by the
// menu server.
//
// File MMTest.cpp

// Set the correct path for you
#include "../MMenu.h"
#include "MMTest.h"
#include "MWindow.h"

//
// main
//

main()
{
	if (TApplication *t = new TApplication)
	{
		t->Run();
		delete t;
	}

	return 0;
}


//
// Constructor
//

TApplication::TApplication() : BApplication("application/x-be-application")
{
	// Create the window
	MWindow *win = new MWindow(BRect(100, 100, 300, 300), "MMTest");

	// Create the messages
	BMessage  *msg1 = new BMessage(B_ABOUT_REQUESTED),
	          *msg2 = new BMessage(MENU_SHARK),
	          *msg3 = new BMessage(MENU_DOG),
	          *msg4 = new BMessage(MENU_GRAPE),
	          *msg5 = new BMessage(MENU_PEACH),
	          *msg6 = new BMessage(B_QUIT_REQUESTED);

	if (!(msg1 && msg2 && msg3 && msg4 && msg5 && msg6 && win))
	{
		PostMessage (B_QUIT_REQUESTED);
		return;
	}

	// Create the items
	BMenuItem *item1 = new BMenuItem("About this", msg1),
	          *item2 = new BMenuItem("Shark", msg2),
	          *item3 = new BMenuItem("Dog", msg3),
	          *item4 = new BMenuItem("Grape", msg4),
	          *item5 = new BMenuItem("Peach", msg5),
	          *item6 = new BMenuItem("Quit this", msg6);

	// Set up the menu
	BPopUpMenu *menu = new BPopUpMenu(NULL, false, false);

	if (!(item1 && item2 && item3 && item4 && item5 && item6 && menu))
	{
		PostMessage (B_QUIT_REQUESTED);
		return;
	}

	// Shark & Dog will be targeted at the window
	item2->SetTarget(win);
	item3->SetTarget(win);

	menu->AddItem(item1);
	menu->AddSeparatorItem();
	menu->AddItem(item2);
	menu->AddItem(item3);
	menu->AddSeparatorItem();
	menu->AddItem(item4);
	menu->AddItem(item5);
	menu->AddSeparatorItem();
	menu->AddItem(item6);

	// Create a WMainMenu from this pop up menu
	if (!(mainmenu = new WMainMenu(menu)) || !mainmenu->MenuSent())
	{
		// Ok, here we haven't been able to export the menu. Several possible causes:
		//   - the user prefers the main menu inside our windows
		//   - the server isn't running
		//   - an error has occurred

		if (mainmenu)
		{
			delete mainmenu;
			mainmenu = NULL;
		}

		// Now add the menu to the window.
		BMenuBar *menubar = new BMenuBar(BRect(0, 0, 200, 200), B_EMPTY_STRING);
		BMenu *wmenu = new BMenu("Main");

		if (!wmenu || !menubar)
		{
			PostMessage(B_QUIT_REQUESTED);
			return;
		}

		// We must transform the BPopUpMenu into a BMenu; let's remove and add the items:
		while (BMenuItem *mi = menu->RemoveItem(0L))
		{
			// Beware of the target !
			if (!mi->Target())
				mi->SetTarget(be_app);

			wmenu->AddItem(mi);
		}

		menubar->AddItem(wmenu);
		win->AddChild(menubar);
	}
	else
		// The menu has been sent; we may get rid of our local copy
		delete menu;

	win->Show();
}


//
// Destructor
//

TApplication::~TApplication()
{
	if (mainmenu)
		delete mainmenu;
}


//
// AppActivated: tell our menu to appear
//

void TApplication::AppActivated (bool isactive)
{
	if (isactive && mainmenu)
		mainmenu->Activate();
}


//
// MessageReceived
//

void TApplication::MessageReceived(BMessage *msg)
{
	char code[5];

	// Endianness: too bad. :)
	memcpy (code, &msg->what, 4);
	code[4] = 0;

	if (BAlert *a = new BAlert("info", "Message received in the application !", code))
		a->Go();
}